% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_Lynch2019}
\alias{bins_Lynch2019}
\title{NMR grouping bins from Lynch et al. (2019).}
\format{
A data frame with 4 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
LM Lynch et al. 2019. “Dissolved Organic Matter Chemistry and
Transport along an Arctic Tundra Hillslope.” Global Biogeochemical Cycles
\doi{10.1029/2018GB006030}
}
\usage{
bins_Lynch2019
}
\description{
NMR grouping bins from Lynch et al. (2019), using D2O as solvent.
(1) methyl, methylene, and methane bearing protons (0.6–1.6 ppm) ;
(2) unsaturated functional groups (1.6–3.2 ppm),
including ketone, benzylic, and alicyclic-bearing protons;
(3) unsaturated, heteroatomic compounds,
including O-bearing carbohydrates, ethers, and alcohols (3.2–4.5 ppm);
(4) conjugated, double bond functionalities,
including aromatic, amide, and phenolic structures (6.5–8.5 ppm).
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}}
\code{\link{bins_Mitchell2018}} \code{\link{bins_Hertkorn2013}}
}
\keyword{datasets}
