% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/011_glev_uni_ln.R
\name{glev_uni_ln}
\alias{glev_uni_ln}
\alias{glev_uni_ln.default}
\alias{glev_uni_ln.formula}
\title{Gaussian-level uniform label noise}
\usage{
\method{glev_uni_ln}{default}(x, y, level, sd = 0.01, sortid = TRUE, ...)

\method{glev_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sd}{a double with the standard deviation for the Gaussian distribution (default: 0.01).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Gaussian-level uniform label noise} into a classification dataset.
}
\details{
For each sample, \emph{Gaussian-level uniform label noise} assigns a random probability 
following a Gaussian distribution of mean = \code{level} and standard deviation \code{sd}. 
Noisy samples are chosen according to these probabilities.
The labels of these samples are randomly
replaced by other different ones within the set of class labels.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- glev_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- glev_uni_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
D. Liu, G. Yang, J. Wu, J. Zhao, and F. Lv. 
\strong{Robust binary loss for multi-category classification with label noise}. 
In \emph{Proc. 2021 IEEE International Conference on Acoustics, Speech and Signal Processing}, 
pages 1700-1704, 2021.
\doi{10.1109/ICASSP39728.2021.9414493}.
}
\seealso{
\code{\link{sym_hienc_ln}}, \code{\link{sym_nexc_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
