% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndmodel.R
\name{plot.ndmodel}
\alias{plot.ndmodel}
\title{Plot function for class ndmodel}
\usage{
\method{plot}{ndmodel}(x, ..., noise = NA, xvar = 1, yvar = 2, pca = FALSE)
}
\arguments{
\item{x}{an object of class \code{ndmodel}.}

\item{...}{other options to pass to the function.}

\item{noise}{a logical indicating which samples to show. The valid options are:
\itemize{
  \item{\code{TRUE}}{: to show only the noisy samples.}
  \item{\code{FALSE}}{: to show only the clean samples.}
  \item{\code{NA}}{: to show both the clean and noisy samples (default value).}
}}

\item{xvar}{an integer with the index of the input attribute (if \code{pca = FALSE}) or the
principal component (if \code{pca = TRUE}) to represent in the \emph{x} axis (default: 1).}

\item{yvar}{an integer with the index of the input attribute (if \code{pca = FALSE}) or the
principal component (if \code{pca = TRUE}) to represent in the \emph{y} axis (default: 2).}

\item{pca}{a logical indicating if PCA must be used (default: \code{FALSE}).}
}
\value{
An object of class \code{ggplot} and \code{gg} with the graph created using the
\code{ggplot2} package.
}
\description{
Representation of the dataset contained in an object of class \code{ndmodel} after the
application of a noise introduction model.
}
\details{
This function performs a two-dimensional representation using the \code{ggplot2} package of
the dataset contained in the object \code{x} of class \code{ndmodel}.
Each of the classes in the dataset (available in \code{x$ynoise}) is represented by a
different color. There are two options to represent the input attributes of the samples
on the \emph{x} and \emph{y} axes of the graph:
\itemize{
  \item{If \code{pca = FALSE}, the values in the graph are taken from the current attribute
  values found in \code{x$xnoise}. In this case, \code{xvar} and \code{yvar} indicate the
  indices of the attributes to show in the \emph{x} and \emph{y} axes, respectively.}
  \item{If \code{pca = TRUE}, the values in the graph are taken after performing a PCA over
  \code{x$xnoise}. In this case, \code{xvar} and \code{yvar} indicate the index of the
  principal component according to the variance explained to show in the \emph{x} and \emph{y}
  axes, respectively.}
}
Finally, the parameter \code{noise} is used to indicate which samples (noisy, clean or all) to show.
Clean samples are represented by circles in the graph, while noisy samples are represented by crosses.
}
\examples{
# load the dataset
data(iris)

# apply the noise introduction model
set.seed(9)
output <- sym_uni_ln(x = iris[,-ncol(iris)], y = iris[,ncol(iris)], level = 0.1)

# plots for all the samples, the clean samples and the noisy samples using PCA
plot(output, pca = TRUE)
plot(output, noise = FALSE, pca = TRUE)
plot(output, noise = TRUE, pca = TRUE)

# plots using the Petal.Length and Petal.Width variables
plot(output, xvar = 3, yvar = 4)
plot(output, noise = FALSE, xvar = 3, yvar = 4)
plot(output, noise = TRUE, xvar = 3, yvar = 4)

}
\seealso{
\code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{sym_uni_ln}}, \code{\link{sym_cuni_ln}}, \code{\link{sym_uni_an}}
}
