% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_noise_threshold_method_statistics.R
\name{calculate_noise_threshold_method_statistics}
\alias{calculate_noise_threshold_method_statistics}
\title{Function to tabulate statistics for different methods of calculating the noise threshold}
\usage{
calculate_noise_threshold_method_statistics(
  expression,
  similarity.threshold.sequence = 0.25,
  method.chosen.sequence = noisyr::get_methods_calculate_noise_threshold(),
  dump.stats = NULL,
  ...
)
}
\arguments{
\item{expression}{either an expression summary (as calculated by
\code{\link{calculate_expression_similarity_counts}} or \code{\link{calculate_expression_similarity_transcript}}),
which should be a list with 3 slots: expression.matrix, expression.levels, expression.levels.similarity;
alternatively, just an expression matrix; only density based methods are available for the latter case}

\item{similarity.threshold.sequence}{similarity (correlation or inverse distance) threshold(s) to be used
to find corresponding noise threshold; can be a single value or a numeric vector;
 the default, 0.25 is usually suitable for the Pearson correlation (the default similarity measure)}

\item{method.chosen.sequence}{methods to use to calculate the noise thresholds,
must be a subset of \code{\link{get_methods_calculate_noise_threshold}}; defaults to all}

\item{dump.stats}{name of csv to export different thresholds calculated (optional)}

\item{...}{other arguments (for the boxplot methods) passed to \code{\link{calculate_noise_threshold}}}
}
\value{
A tibble containing information on noise thresholds calculated using the input
similarity thresholds and methods (optionally written in a csv file).
The columns list the chosen method and similarity threshold, the minimum, mean,
coefficient of variation, and maximum of the noise thresholds, and all the noise thresholds
concatenated as a string.
}
\description{
This function is used to tabulate and compare different combinations of similarity
threshold and method to calculate the noise threshold for a given expression matrix.
}
\examples{
expression.summary <- calculate_expression_similarity_counts(
    expression.matrix = matrix(1:100, ncol=5),
    method = "correlation_pearson",
    n.elements.per.window = 3)
calculate_noise_threshold_method_statistics(expression.summary)
}
\seealso{
\code{\link{calculate_noise_threshold}}
}
