% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbouch.R
\name{elbouch.statistic}
\alias{elbouch.statistic}
\title{Computes El Bouch, et al.'s z statistic.}
\usage{
elbouch.statistic(y, x = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{x}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}
}
\value{
a real value with El Bouch test's statistic.
}
\description{
Computes the El Bouch, Michel, & Comon's z test statistic for normality of
a univariate or bivariate time series.
}
\details{
This function computes Mardia's standardized `z = (B - E_B)/ sd_B` statistic
corrected by El Bouch, et al. (2022) for stationary bivariate time series. Where:
`B` is the square of a quadratic form of the process `c(y, x)`; `E_B` and `sd_B` are
the estimator's expected value and standard error respectively.  If `x` is set to
`NULL`, the test computes the univariate counterpart.
}
\examples{
# Genere an univariate stationary ARMA process
y = arima.sim(100,model = list(ar = 0.3))
elbouch.statistic(y)

# Generate a bivariate Gaussian random vector
x = rnorm(200)
y = rnorm(200)
elbouch.statistic(y = y, x = x)

}
\references{
El Bouch, S., Michel, O. & Comon, P.  (2022). A normality test for Multivariate dependent
samples. \emph{Journal of Signal Processing}. Volume 201.

Mardia, K. (1970). Measures of multivariate skewness and kurtosis with applications.
\emph{Biometrika}, 57 519-530

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.statistic}}
}
\author{
Asael Alonzo Matamoros.
}
