% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_2-1_1.R
\name{rSurv_conditional_fun}
\alias{rSurv_conditional_fun}
\title{Draw conditional random survival times from mixpch object.}
\usage{
rSurv_conditional_fun(x, y)
}
\arguments{
\item{x}{An object of class \code{mixpch}}

\item{y}{A vector of observed right censored times}
}
\value{
A vector of random survival times, conditional on the observed censored times.
}
\description{
Draws independent random survival times from \code{mixpch} objects conditional on
observed time.
}
\details{
\preformatted{Note that the mixpch object stores the survival function up to some time T. For random times equal or larger T, the value T is returned.
}
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
rSurv_conditional_fun(x = A, y = c(10,15,9,2,1))
}
\references{
Robin Ristl, Nicolas Ballarini, Heiko Götte, Armin Schüler, Martin Posch, Franz König. Delayed treatment effects, treatment switching and
heterogeneous patient populations: How to design and analyze RCTs in oncology. Pharmaceutical statistics. 2021; 20(1):129-145.
}
\seealso{
\code{\link{rSurv_fun}}, \code{\link{sample_fun}}, \code{\link{sample_conditional_fun}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
