% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{as.xbt}
\alias{as.xbt}
\title{Create an xbt Object}
\usage{
as.xbt(
  z,
  temperature,
  longitude = NA,
  latitude = NA,
  filename = "",
  sequenceNumber = NA,
  serialNumber = ""
)
}
\arguments{
\item{z}{numeric vector giving vertical coordinates of measurements. This is the negative of
depth, i.e. \code{z} is 0 at the air-sea interface, and negative within the water column.}

\item{temperature}{numeric vector giving in-situ temperatures at the \code{z} values.}

\item{longitude, latitude}{location in degE and degN.}

\item{filename}{character value naming source file.}

\item{sequenceNumber}{numerical value of the sequence number of the XBT drop.}

\item{serialNumber}{character value holding the serial number of the XBT.}
}
\value{
An \linkS4class{xbt} object.
}
\description{
Create an xbt Object
}
\seealso{
Other things related to xbt data: 
\code{\link{[[,xbt-method}},
\code{\link{[[<-,xbt-method}},
\code{\link{plot,xbt-method}},
\code{\link{read.xbt}()},
\code{\link{read.xbt.noaa1}()},
\code{\link{subset,xbt-method}},
\code{\link{summary,xbt-method}},
\code{\link{xbt}},
\code{\link{xbt-class}},
\code{\link{xbt.edf}}
}
\author{
Dan Kelley
}
\concept{things related to xbt data}
