% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_offset.R
\name{boost_tree_offset}
\alias{boost_tree_offset}
\title{Boosted Poisson Trees with Offsets}
\usage{
boost_tree_offset(
  mode = "regression",
  engine = "xgboost_offset",
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  stop_iter = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "regression"}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{mtry}{A number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models
(specific engines only).}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that is required for the node to be split further.}

\item{tree_depth}{An integer for the maximum depth of the tree (i.e. number
of splits) (specific engines only).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration (specific engines only). This is sometimes referred to
as the shrinkage parameter.}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further (specific engines only).}

\item{sample_size}{A number for the number (or proportion) of data that is
exposed to the fitting routine. For \code{xgboost}, the sampling is done at
each iteration while \code{C5.0} samples once during training.}

\item{stop_iter}{The number of iterations without improvement before
stopping (specific engines only).}
}
\value{
A model specification object with the classes \code{boost_tree_offset} and
\code{model_spec}.
}
\description{
\code{boost_tree_offset()} defines a model that creates a series of Poisson
decision trees with pre-defined offsets forming an ensemble. Each tree
depends on the results of previous trees. All trees in the ensemble are
combined to produce a final prediction. This function can be used for count
regression models only.
}
\details{
This function is similar to \code{\link[parsnip:boost_tree]{parsnip::boost_tree()}} except that
specification of an offset column is required.
}
\examples{
parsnip::show_model_info("boost_tree_offset")

boost_tree_offset()

}
\seealso{
\code{\link[parsnip:boost_tree]{parsnip::boost_tree()}}
}
