% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_tibbles_uniprot}
\alias{compare_tibbles_uniprot}
\title{Compare Input and Updated Tibbles}
\usage{
compare_tibbles_uniprot(
  original_tibble,
  updated_tibble,
  entry_name_col = "entry_name",
  protein_name_col = "protein_name",
  gene_name_col = "gene_name"
)
}
\arguments{
\item{original_tibble}{The original tibble before processing.}

\item{updated_tibble}{The tibble returned after processing.}

\item{entry_name_col}{The column name for entry names (default: "entry_name").}

\item{protein_name_col}{The column name for protein names (default: "protein_name").}

\item{gene_name_col}{The column name for gene names (default: "gene_name").}
}
\value{
None. Prints the differences between the tibbles.
}
\description{
This function compares the original input tibble and the updated tibble,
identifying and reporting any changes in the specified columns (`entry_name`, `protein_name`, `gene_name`).
}
\examples{
# Example usage:
\donttest{
# Original input tibble
input_data <- tibble::tibble(
  id = c(1, 2),
  species = c("mouse", "rat"),
  sample_type = c("brain", "liver"),
  accession = c("O88737", "Q9R064"),
  accession_source = c("UniProt", "UniProt")
)

# Process the tibble (this will add the entry_name, protein_name, and gene_name)
processed_data <- process_tibble_uniprot(input_data)

# Compare the original and processed tibbles
compare_tibbles_uniprot(input_data, processed_data)
}
}
