% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-progress.R
\name{format_time_overlap_bar}
\alias{format_time_overlap_bar}
\title{Format and print date overlaps}
\usage{
format_time_overlap_bar(
  start,
  end,
  targets,
  targetrange = FALSE,
  twobar = FALSE,
  width = NULL,
  style = list()
)
}
\arguments{
\item{start}{the date that the reference period begins (as Date object).}

\item{end}{the date that the reference period ends (as Date object).}

\item{targets}{a vector of dates.}

\item{targetrange}{is the target a range? If so this will treat the first two elements of \code{targets} as the start and end of the range.}

\item{twobar}{whether to render as two bars or as one with different colours for overlaps.}

\item{width}{the width of the bars in characters. Defaults to 0.5 * console width.}

\item{style}{a style from \code{\link[cli:cli_progress_styles]{cli::cli_progress_styles()}} to use as a format.}
}
\value{
No return value
}
\description{
Format and output to the terminal a visualisation of the overlaps between a given period and another set of dates.
This is mostly used in the error handling of \code{\link[=glean_ad]{glean_ad()}} however it can also be used independently.
It was designed to fill a more general role within UI design using the cli package, and should be usable (or hackable) by others needing the same tool.
}
\examples{
format_time_overlap_bar(
  start = as.Date("2022-08-04"),
  end = as.Date("2022-08-11"),
  targets = c(as.Date("2022-08-05"), as.Date("2022-08-12")),
  targetrange = TRUE, twobar=TRUE
)


}
\author{
Francis Windram
}
