% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-hadi-plot.R
\name{ols_plot_hadi}
\alias{ols_plot_hadi}
\title{Hadi plot}
\usage{
ols_plot_hadi(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Hadi's measure of influence based on the fact that influential observations
can be present in either the response variable or in the predictors or both.
The plot is used to detect influential observations based on Hadi's measure.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_hadi(model)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\seealso{
\code{\link[=ols_plot_resid_pot]{ols_plot_resid_pot()}}
}
