% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_grid.R
\name{annotation_grid}
\alias{annotation_grid}
\title{Get logical matrix of term annotation for group of cases}
\usage{
annotation_grid(
  ontology,
  term_sets,
  all_terms = grid_terms(ontology, term_sets),
  remove_unanimous = FALSE,
  cluster_rows = TRUE,
  cluster_cols = TRUE
)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}

\item{all_terms}{Character vector giving terms to use in annotation.}

\item{remove_unanimous}{Logical value determining whether to remove terms present in all \code{term_sets}.}

\item{cluster_rows}{Logical value rows determining whether to use hclust to cluster \code{term_sets}.}

\item{cluster_cols}{Logical value rows determining whether to use hclust to cluster terms (based on correlation of inclusion in \code{term_sets}).}
}
\value{
Logical matrix.
}
\description{
Get logical matrix of term annotation for group of cases
}
