% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{normalize_KDE}
\alias{normalize_KDE}
\title{Normalize loess smoothing}
\usage{
normalize_KDE(tree.discr, Maps.mean.loess)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Maps.mean.loess}{list. A list with the loess smoothing calculated for each edge using the 'loess_smoothing_KDE' function.}
}
\value{
A list with the normalized loess smoothing calculated for each edge.
}
\description{
Normalizes the loess smoothing for the Markov KDE.
}
\examples{
data("hym_kde", "hym_tree")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get non-normalized and normalized edge KDE data.
Edge_KDE <- hym_kde$head
# Calculate smoothing of edge KDE data.
Edge_KDE$Maps.mean.loess <- suppressWarnings(loess_smoothing_KDE(tree_discr, Edge_KDE))
# Normalize smoothing edge KDE data.
Edge_KDE$Maps.mean.loess.norm <- normalize_KDE(tree_discr, Edge_KDE$Maps.mean.loess)
# Check smoothing of KDE data for non-normalized mean rates from an arbitrary branch.
Edge_KDE$Maps.mean.loess[[5]]

}
\author{
Sergei Tarasov
}
