% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_frames.R
\name{get_ts}
\alias{get_ts}
\alias{valid_ts_variables}
\alias{valid_at_age_ts_variables}
\alias{get_ts.Hist}
\alias{get_ts.MSE}
\alias{get_ts.list}
\alias{get_ts.multiHist}
\alias{get_ts.MMSE}
\alias{get_Biomass}
\alias{get_Landings}
\alias{get_Removals}
\alias{get_Recruits}
\alias{get_SSB}
\alias{get_SB_SBMSY}
\alias{get_F}
\alias{get_Biomass_at_Age}
\alias{get_Number_at_Age}
\alias{get_SSB_at_Age}
\title{Create a data.frame with time-series information by simulation and year}
\usage{
get_ts(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

valid_ts_variables()

valid_at_age_ts_variables()

\method{get_ts}{Hist}(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

\method{get_ts}{MSE}(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

\method{get_ts}{list}(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

\method{get_ts}{multiHist}(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

\method{get_ts}{MMSE}(x, variable = "Spawning Biomass", model = "Model 1", scale = NULL)

get_Biomass(x, model = "Model 1", ...)

get_Landings(x, model = "Model 1", ...)

get_Removals(x, model = "Model 1", ...)

get_Recruits(x, model = "Model 1", ...)

get_SSB(x, model = "Model 1", ...)

get_SB_SBMSY(x, model = "Model 1", ...)

get_F(x, model = "Model 1", ...)

get_Biomass_at_Age(x, model = "Model 1", ...)

get_Number_at_Age(x, model = "Model 1", ...)

get_SSB_at_Age(x, model = "Model 1", ...)
}
\arguments{
\item{x}{An object of class \code{Hist}, \code{MSE}, or a list of \code{Hist} or \code{MSE} objects}

\item{variable}{A character string with a valid name for a time-series variable.
Use \code{valid_ts_variables()} for valid variable names.}

\item{model}{An optional name for the model.
If \code{x} is a list of objects, \code{model} will be taken from \code{names(x)}.
If \code{names(x)} is \code{NULL}, \code{model} will be given sequential numerical values (e.g., \verb{Model 1}, \verb{Model 2}, ...)}

\item{scale}{An optional function with a single numeric argument that returns transformed or scaled numeric values. See \code{lb2kg} and \code{kg2lb} for example.
Can be a list of functions for list objects (NA for no transformation)}

\item{...}{named arguments passed to \code{get_ts}}
}
\description{
Create a data.frame with time-series information by simulation and year
}
