#' 200 records of Sample Input
#'
#' This is a dataset consisting of 200 arbitrary sample input neonatal deaths 
#' in the acceptable format of InterVA5.
#'
#'
#' @name NeonatesVA5
#' @docType data
#' @format 200 arbitrary input records.
#' @keywords datasets
#' @examples
#'
#' data(NeonatesVA5)
#'
NULL

#' 1,736 records of Sample Input
#'
#' This is a dataset of 1,736 arbitrary (neonate and child) deaths in the
#' acceptable format of EAVA.  It is meant to be comparable
#' to the RandomVA6 examples data set.
#'
#'
#' @name DataEAVA
#' @docType data
#' @format 1,736 arbitrary input records.
#' @keywords datasets
#' @examples
#'
#' data(DataEAVA)
#'
NULL

#' 1,736 records of Sample Input
#'
#' This is a dataset consisting of 1,736 (neonate and child) deaths in
#' the acceptable format of InSilicoVA.  It is meant to be comparable
#' to the DataEAVA examples data set.
#'
#'
#' @name RandomVA6
#' @docType data
#' @format 1,736 arbitrary input records.
#' @keywords datasets
#' @examples
#'
#' data(RandomVA6)
#'
NULL

#' Mapping for neonate causes of death to the list used by the EAVA algorithm.
#' 
#' Intended for use when comparing assigned causes of death between
#' the EAVA algorithm and InSilicoVA/InterVA5.
#'
#'#'
#' @name grouping_eava_neonate
#' @docType data
#' @format Data Frame
#' @keywords datasets
#' @examples
#'
#' data(grouping_eava_neonate)
#'
NULL

#' Mapping for child causes of death to the list used by the EAVA algorithm.
#' 
#' Intended for use when comparing assigned causes of death between
#' the EAVA algorithm and InSilicoVA/InterVA5.
#'
#'#'
#' @name grouping_eava_child
#' @docType data
#' @format Data Frame
#' @keywords datasets
#' @examples
#'
#' data(grouping_eava_child)
#'
NULL