% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{AnyOf}
\alias{AnyOf}
\title{AnyOf}
\value{
Object of \code{\link[R6:R6Class]{R6::R6Class()}} representing an argument choice object.
}
\description{
Inheriting from \link{Argument} in order to represent an argument choice object. Multiple
types can be stated, but at least one data type has to be picked. In a JSON-schema this is often used to make
objects nullable - meaning that they allow NULL as value. The AnyOf parameter is resolved into a simple nullable argument
if this applies.
}
\section{Methods}{

\describe{
\item{\verb{$getChoice()}}{returns a list of \link{Argument} that are allowed}
\item{\verb{$isNullable}}{returns TRUE if only one element is in the choice that is not "null"}
}
}

\seealso{
\link{Array}, \link{Integer}, \link{EPSGCode}, \link{String}, \link{Number},
\link{Date}, \link{DataCube}, \link{ProcessGraphArgument},
\link{ProcessGraphParameter}, \link{OutputFormatOptions}, \link{GeoJson},
\link{Boolean}, \link{DateTime}, \link{Time}, \link{BoundingBox}, \link{Kernel},
\link{TemporalInterval}, \link{TemporalIntervals}, \link{CollectionId}, \link{OutputFormat},
\link{AnyOf}, \link{ProjDefinition}, \link{UdfCodeArgument}, \link{UdfRuntimeArgument} and
\link{UdfRuntimeVersionArgument}, \link{MetadataFilter}
}
