% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_functions.R
\name{opt.ci}
\alias{opt.ci}
\title{Confidence bands optimized by area}
\usage{
opt.ci(survi, conf.level = 0.95, fun = "surv", tl = NA, tu = NA, samples = 1)
}
\arguments{
\item{survi}{a \code{survfit} object.}

\item{conf.level}{desired coverage level.}

\item{fun}{"surv" for survival function and "cumhaz" for the cumulative-hazard.
function, with "surv" as the default.}

\item{tl}{a lower bound for truncation.}

\item{tu}{an upper bound for truncation.}

\item{samples}{the number of groups (1 or 2).}
}
\value{
A \code{survfit} object with optimized confidence bands.
}
\description{
\code{opt.ci} obtains simultaneous confidence bands for the survival or
cumulative-hazard functions such that the area between is minimized.
}
\details{
Produces an approximate solution based on local time arguments.
}
\examples{
library(survival)
# fit and plot a Kaplan-Meier curve
fit <- survfit(Surv(stop, event) ~ 1, data=bladder)
plot(fit)
fit2 <- opt.ci(fit)
plot(fit2)

}
