% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_mult.R
\name{opt_des}
\alias{opt_des}
\title{Calculates the optimal design for a specified criterion}
\usage{
opt_des(
  criterion,
  model,
  parameters,
  par_values = c(1),
  design_space,
  init_design = NULL,
  join_thresh = -1,
  delete_thresh = 0.02,
  delta = 1/2,
  tol = 1e-05,
  tol2 = 1e-05,
  par_int = NULL,
  matB = NULL,
  reg_int = NULL,
  desired_output = c(1, 2),
  distribution = NA,
  weight_fun = function(x) 1
)
}
\arguments{
\item{criterion}{character variable with the chosen optimality criterion. Can be one of the following:
\itemize{
\item 'D-Optimality'
\item 'Ds-Optimality'
\item 'A-Optimality'
\item 'I-Optimality'
\item 'L-Optimality'
}}

\item{model}{formula describing the model to calculate the optimal design. Must use x as the variable.}

\item{parameters}{character vector with the parameters of the models, as written in the \code{formula}.}

\item{par_values}{numeric vector with the parameters nominal values, in the same order as given in \code{parameters}.}

\item{design_space}{numeric vector with the limits of the space of the design.}

\item{init_design}{optional dataframe with the initial design for the algorithm. A dataframe with two columns:
\itemize{
\item \code{Point} contains the support points of the design.
\item \code{Weight} contains the corresponding weights of the \code{Point}s.
}}

\item{join_thresh}{optional numeric value that states how close, in real units, two points must be in order to
be joined together by the join heuristic.}

\item{delete_thresh}{optional numeric value with the minimum weight, over 1 total, that a point needs to have
in order to not be deleted from the design.}

\item{delta}{optional numeric value in (0, 1), parameter of the algorithm.}

\item{tol}{optional numeric value for the convergence of the weight optimizing algorithm.}

\item{tol2}{optional numeric value for the stop criterion: difference between maximum of sensitivity function
and optimality criterion.}

\item{par_int}{optional numeric vector with the index of the \code{parameters} of interest for Ds-optimality.}

\item{matB}{optional matrix of dimensions k x k, for L-optimality.}

\item{reg_int}{optional numeric vector of two components with the bounds of the interest region for I-Optimality.}

\item{desired_output}{not functional yet: decide which kind of output you want.}

\item{distribution}{character variable specifying the probability distribution of the response. Can be one of the following:
\itemize{
\item 'Homoscedasticity'
\item 'Gamma', which can be used for exponential or normal heteroscedastic with constant relative error
\item 'Poisson'
\item 'Logistic'
\item 'Log-Normal' (work in progress)
}}

\item{weight_fun}{optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response.}
}
\value{
a list of two objects:
\itemize{
\item optdes: a dataframe with the optimal design in two columns, \code{Point} and \code{Weight}.
\item sens: a plot with the sensitivity function to check for optimality of the design.
}
}
\description{
The opt_des function calculates the optimal design for an optimality criterion and a model input from the user.
The parameters allows for the user to customize the parameters for the cocktail algorithm in case the default
set does not provide a satisfactory output. Depending on the criterion, additional details are necessary.
For 'Ds-Optimality' the par_int parameter is necessary. For 'I-Optimality' either the matB or reg_int must
be provided.
}
\examples{
opt_des("D-Optimality", y ~ a * exp(-b / x), c("a", "b"), c(1, 1500), c(212, 422))
}
