% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_roots.R
\name{get_roots_over}
\alias{get_roots_over}
\title{Get the root nodes of a graph over some nodes}
\usage{
get_roots_over(graph, nodes)
}
\arguments{
\item{graph}{A graph object}

\item{nodes}{A character vector of nodes to find roots for}
}
\value{
A character vector of nodes
}
\description{
Retrieves the nodes in a graph that have no parents
over a certain node or group of nodes
}
\examples{
graph <- graph_builder() |>
  add_path(c("A", "B", "C")) |>
  add_path(c("A", "D", "C")) |>
  add_path(c("Z", "B", "C")) |>
  build_directed()

get_roots_over(graph, "D")
}
\seealso{
Other analyze graphs: 
\code{\link{find_all_paths}()},
\code{\link{find_path}()},
\code{\link{find_path_one_to_many}()},
\code{\link{get_all_leaves}()},
\code{\link{get_all_roots}()},
\code{\link{get_leaves_under}()},
\code{\link{least_common_parents}()}
}
\concept{analyze graphs}
