% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/places_api.R
\name{query_postcode_places}
\alias{query_postcode_places}
\title{Query the OS Places API}
\usage{
query_postcode_places(
  postcode,
  output_crs = "EPSG:27700",
  limit = 100,
  classification_code,
  logical_status_code,
  dataset = "DPA",
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)
}
\arguments{
\item{postcode}{The postcode search parameter as a character.}

\item{output_crs}{(character or numeric) The output CRS. Defaults to
“EPSG:27700”. Other options are EPSG:4326 or EPSG:3857.}

\item{limit}{(numeric) The maximum number of features to return. Default is
100 which is the max return per page from the Data Hub.}

\item{classification_code}{Classification codes to filter query by.}

\item{logical_status_code}{Logical status code to filter query by.}

\item{dataset}{(character) The dataset to return. Multiple values can be
provided as a vector. Default is 'DPA'.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{returnType}{(character) Return the query results as the raw
\code{'geojson'}, a nested \code{'list'} object containing the returns,
or convert them into Simple Features and return an object of class
\code{'sf'}.}

\item{...}{Additional parameters (not currently used).}
}
\value{
A GeoJSON string with the results of the API query, a list object,
or an object of class \code{sf} based on the \code{returnType} parameter.
}
\description{
A query of addresses based on a property's postcode.
}
\details{
The OS Places API provides a detailed view of an address and its
life cycle. Use this function to query Places based on a postcode search.
The minimum search parameter for this resource is the postcode area and
postcode district. For example, 'SO16' is a valid search. Full postcodes,
consisting of area, district, sector and unit, e.g. SO16 0AS can also be
supplied.

The Places API contains all the records of AddressBase® Premium and
AddressBase® Premium – Islands and so provides all the information relating
to an address or property from creation to retirement. It contains local
authority, Ordnance Survey and Royal Mail® addresses, current addresses,
and alternatives for current addresses, provisional addresses (such as
planning developments) and historic information, plus OWPAs and cross
references to the OS MasterMap® TOIDS®. OS Places API contains addresses
located within the United Kingdom, Jersey, Guernsey and the Isle of Man.
For address records in Jersey and Guernsey the coordinates will be ‘0.0’ as
they fall outside of the British National Grid. This means they are not
compatible with the GeoSearch operations.

Technical details on the Places API are documented on the Data Hub:
\url{https://osdatahub.os.uk/docs/places/technicalSpecification}.

Note: the Places API requires a Premium API key.
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
results <- query_postcode_places(postcode = 'SO16 0AS')
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=query_places]{query_places()}}, \code{\link[=query_nearest_places]{query_nearest_places()}}, \code{\link[=query_uprn_places]{query_uprn_places()}}
}
