% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_elements.R
\name{osm_ways_node}
\alias{osm_ways_node}
\title{Ways of a node}
\usage{
osm_ways_node(node_id, format = c("R", "xml", "json"), tags_in_columns = FALSE)
}
\arguments{
\item{node_id}{Node id represented by a numeric or a character value.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}

\item{tags_in_columns}{If \code{FALSE} (default), the tags of the objects are saved in a single list column \code{tags}
containing a \code{data.frame} for each OSM object with the keys and values. If \code{TRUE}, add a column for each key.
Ignored if \code{format != "R"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one OSM object per row. If \code{format = "xml"}, returns a
\link[xml2:oldclass]{xml2::xml_document} following the
\href{https://wiki.openstreetmap.org/wiki/OSM_XML#OSM_XML_file_format_notes}{OSM_XML format}. If \code{format = "json"},
returns a list with a json structure following the \href{https://wiki.openstreetmap.org/wiki/OSM_JSON}{OSM_JSON format}.
}
\description{
Returns all the (not deleted) ways in which the given node is used.
}
\examples{
ways_node <- osm_ways_node(node_id = 35308286)
ways_node
}
\seealso{
Other get OSM objects' functions: 
\code{\link{osm_bbox_objects}()},
\code{\link{osm_get_objects}()},
\code{\link{osm_history_object}()},
\code{\link{osm_relations_object}()},
\code{\link{osmapi_objects}()}
}
\concept{get OSM objects' functions}
