% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{osm_tags_df}
\alias{osm_tags_df}
\title{Extract Tags as Columns from an OSM PBF Layer}
\usage{
osm_tags_df(data, tags, na.prop = 0)
}
\arguments{
\item{data}{an imported layer from an OSM PBF file. Usually has a few important tags already expanded as columns, and an 'other_tags' column which compounds less frequent tags as character strings.}

\item{tags}{character. A vector of tags to extract as columns.}

\item{na.prop}{double. Proportion of features having a tag in order to keep the column.}
}
\value{
a \emph{data.table} with the supplied \code{tags} as columns, and the same number of rows as the input frame.
}
\description{
Extract Tags as Columns from an OSM PBF Layer
}
\examples{
# See Examples at ?osmclass for full examples

# Extracting tags of interest (some of which are inside 'other_tags')
tags <- c("osm_id", "highway", "man_made", "name", "alt_name",
          "description", "wikidata", "amenity", "tourism")
head(osm_tags_df(djibouti_points, tags))

# Only keeping tags with at least 5\\% non-missing
head(osm_tags_df(djibouti_points, tags, na.prop = 0.05))

}
\seealso{
\link{osmclass-package}
}
