% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneBurdenQuery.R
\name{geneBurdenQuery}
\alias{geneBurdenQuery}
\title{Retrieve Gene Burden data for a specified gene and disease.}
\usage{
geneBurdenQuery(ensemblId, efoId, size = 3500)
}
\arguments{
\item{ensemblId}{Character: ENSEMBL ID of the target gene (e.g., "ENSG00000137642").}

\item{efoId}{Character: EFO ID of the target disease (e.g., "MONDO_0004975").}

\item{size}{Integer: Number of records to retrieve (default: 3500).}
}
\value{
Returns a tibble containing gene burden evidence data for the specified gene and disease.
}
\description{
This function queries the Open Targets GraphQL API to retrieve gene burden evidence data
for a specified gene and disease.
}
\examples{
\dontrun{
result <- geneBurdenQuery(ensemblId = "ENSG00000137642", efoId = 
"MONDO_0004975", size = 3500)
}
}
