% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneOntologyQuery.R
\name{geneOntologyQuery}
\alias{geneOntologyQuery}
\title{Retrieve Gene Ontology data for a specified gene.}
\usage{
geneOntologyQuery(ensgId)
}
\arguments{
\item{ensgId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000141510).}
}
\value{
Returns a tibble containing gene ontology data for the specified gene.
}
\description{
This function queries the Open Targets GraphQL API to retrieve gene ontology data
for a specified gene.
}
\examples{
\dontrun{
result <- geneOntologyQuery(ensgId = "ENSG00000141510")
}
}
