% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heading.R
\name{rangeHeading}
\alias{rangeHeading}
\alias{dateHeading}
\title{Headings for overlay dropdown menus}
\usage{
rangeHeading(..., sep = " - ")

dateHeading(format, ..., sep = " - ")
}
\arguments{
\item{...}{Further arguments to be passed to \code{\link[=format]{format()}}, such as \code{digits},
\code{scientific}, etc. See the documentation for \code{\link[=format]{format()}} for details.}

\item{sep}{A separator that will be inserted between the start and end
position of the overlay. Use \code{NULL} to only print the start position.}

\item{format}{For \code{\link[=dateHeading]{dateHeading()}} only, the date format to use, e.g.
"\%Y-\%m-\%d". See the documentation for \code{\link[=format.Date]{format.Date()}} for details.}
}
\value{
A heading function suitable to pass to \code{\link[=overlayServer]{overlayServer()}} as the
\code{heading} argument.
}
\description{
Use a call to one of these functions as the \code{heading} parameter of
\code{\link[=overlayServer]{overlayServer()}} to provide a heading on the overlay dropdown menu
reporting the start and end position of the overlay. For numbers, the
heading from \code{\link[=rangeHeading]{rangeHeading()}} will be e.g. "1.5 - 3.5". For dates, the
heading from \code{\link[=dateHeading]{dateHeading()}} will be e.g. "2025-05-01 - 2025-06-01".
}
\examples{
server <- function(input, output) {
    ov <- overlayServer("my_plot", 8, heading = dateHeading("\%b \%d"))
    # further server code here . . .
}

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
