% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_crosstab.R
\name{overview_crosstab}
\alias{overview_crosstab}
\title{overview_crosstab}
\usage{
overview_crosstab(dat, cond1, cond2, threshold1, threshold2, id, time)
}
\arguments{
\item{dat}{A data set object}

\item{cond1}{Variable that describes the first condition}

\item{cond2}{Variable that describes the second condition}

\item{threshold1}{A threshold for \code{cond1}}

\item{threshold2}{A threshold for \code{cond2}}

\item{id}{Scope (e.g., country codes or individual IDs)}

\item{time}{Time (e.g., time periods given by years, months, ...)}
}
\value{
A data frame object that contains a summary of the data set that can
      later be converted to a 'LaTeX' output using \code{overview_latex}
}
\description{
Sorts a data set conditionally in a cross table.
    This can be helpful to get a sense of the time and scope
    conditions of a data set. Note, if used with a data set that has multiple
    observations on the id-time unit, the function automatically aggregates
    this information using the mean.
}
\examples{
data(toydata)
overview_crosstab(
  dat = toydata,
  cond1 = gdp,
  cond2 = population,
  threshold1 = 25000,
  threshold2 = 27000,
  id = ccode,
  time = year
)
}
