% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{module_networks}
\alias{module_networks}
\title{Get module level networks}
\usage{
module_networks(
  data,
  k = 10,
  quantile_cutoff = 10,
  centrality_degree_mod = "out",
  components_mod = "weak",
  network_min_genes = 10
)
}
\arguments{
\item{data}{distance matrix}

\item{k}{number of gene clusters for module inference}

\item{quantile_cutoff}{distance cutoff based on quantile(1-99) for edge identification}

\item{centrality_degree_mod}{"in" or "out" for nodes popularity calculation}

\item{components_mod}{"weak" or "strong" for sub-network components inference}

\item{network_min_genes}{minial number of genes required for a network}
}
\value{
a list networks for each module
}
\description{
Given a distance matrix, calculate gene modules based on hierarchical clustering method and then get module level networks
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)
nets <- module_networks(dtw_dist_matrix,k=1,quantile_cutoff=50)
plot_network(nets[["module1"]])
}
