% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_binary}
\alias{check_binary}
\title{Check binary}
\usage{
check_binary(..., df, max_view = 50)
}
\arguments{
\item{...}{character vector. This character vector contains the name of the variables of which the sum will be checked.}

\item{df}{a dataframe.}

\item{max_view}{numeric. Determines the number of iterations to display which do not fulfill the check. Default is 50.}
}
\value{
A dataframe.
}
\description{
This function tests whether the value of variables remain between 0 and 1 (for instance for utility and probability inputs)
}
\examples{
# Checking whether a variable is strictly positive
data(df_pa)
check_binary("u_pfs", df = df_pa)
# Checking whether two variables are strictly positive
# Decreasing the number of iterations to display to 20.
check_binary("u_pfs", "p_pfspd", df = df_pa)
}
