% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_hemodel.R
\name{perform_simulation_psm}
\alias{perform_simulation_psm}
\title{Perform the health economic simulation using partitioned survival model.}
\usage{
perform_simulation_psm(l_params, min_fct = TRUE)
}
\arguments{
\item{l_params}{list. List of inputs of the health economic model.}

\item{min_fct}{logical. Should a minimum function be used to ensure PFS remains lower than OS? Default is TRUE.}
}
\value{
A vector. This vector contains the (un)discounted intermediate and final outcomes of the health economic model.
}
\description{
This function performs the simulation of the partitioned survival health economic model developed to test the functionalities of the package.
}
\examples{
# Perform the simulation using one iteration of the probabilistic model inputs
l_inputs_det <- as.list(generate_pa_inputs_psm(n_sim = 1))
v_results_det <- perform_simulation_psm(l_inputs_det)
}
