% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timemachine.R
\name{pac_timemachine}
\alias{pac_timemachine}
\title{Package metadata for all releases}
\usage{
pac_timemachine(
  pac,
  at = NULL,
  from = NULL,
  to = NULL,
  version = NULL,
  source = c("cran", "crandb")
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{at}{\code{Date} from which to take the version. Default: \code{NULL}}

\item{from}{\code{Date} the lower limit. Default: \code{NULL}}

\item{to}{\code{Date} the upper limit. Default: \code{NULL}}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{source}{\code{character} one of \code{c("cran", "crandb")}.
Using the \verb{MEATCRAN CRANDB} or the direct web page download from CRAN.
When \code{"crandb"} is set then \code{options(pacs.crandb_ntry = 3)} and \code{options(pacs.crandb_nsleep = 0.001)} can be used to control the fetch.
\code{"pacs.crandb_ntry"} can be used to set the maximum number of try outs, by default 3.
\code{"pacs.crandb_nsleep"} can be used to set the sleep duration between fetch try outs, by default 0.001.
Default: \code{"cran"}}
}
\value{
\code{data.frame} with 7 columns
\describe{
\item{Package}{character package name.}
\item{Version}{character package version.}
\item{Released}{character release Date}
\item{Archived}{character archived Date.}
\item{LifeDuration}{\code{difftime} number of days the version was the newest one.}
\item{URL}{character the suffix of the base URL to \code{tar.gz} file. The base part of URL in the result is \verb{https://cran.r-project.org/src/contrib/}.}
\item{Size}{character size of the \code{tar.gz} file.}
}
}
\description{
Using CRAN website to get a package metadata used at a specific Date or a Date interval or for specific version.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_timemachine("dplyr")
pacs::pac_timemachine("dplyr", at = as.Date("2017-02-02"))
pacs::pac_timemachine("dplyr", from = as.Date("2017-02-02"), to = as.Date("2018-04-02"))
pacs::pac_timemachine("dplyr", at = Sys.Date())
pacs::pac_timemachine("tidyr", from = as.Date("2020-06-01"), to = Sys.Date())
}
}
