% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/included-palettes.R
\docType{data}
\name{met_palettes}
\alias{met_palettes}
\alias{met_palettes_a11y}
\title{Metropolitan Museum of Art palettes}
\format{
\subsection{\code{met_palettes}}{

An object of class \code{palettes_palette} with 56 colour
palettes. Use \code{names(met_palettes)} to return all palette names.
}

\subsection{\code{met_palettes_a11y}}{

An object of class \code{palettes_palette} limited to
24 colourblind accessible palettes. All colours
in each palette are distinguishable with deuteranopia, protanopia, and
tritanopia. Use \code{names(met_palettes_a11y)} to return all palette names.
}
}
\source{
\url{https://github.com/BlakeRMills/MetBrewer}
}
\usage{
met_palettes

met_palettes_a11y
}
\description{
Palettes inspired by works at the Metropolitan Museum of Art in New York.
Pieces selected come from various time periods, regions, and mediums.
}
\examples{
# Get all palettes by name.
names(met_palettes)

# Plot all palettes.
plot(met_palettes)
}
\seealso{
\code{\link[=pal_palette]{pal_palette()}}, \code{\link[=pal_colour]{pal_colour()}}, \code{\link[MetBrewer:met.brewer]{MetBrewer::met.brewer()}}
}
\author{
\href{https://github.com/BlakeRMills}{Blake Robert Mills}
}
\keyword{datasets}
