% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_collection.R
\name{parse_collection}
\alias{parse_collection}
\alias{parse_qmd_collection}
\alias{parse_rmd_collection}
\title{Parse a collection of R Markdown or Quarto document}
\usage{
parse_qmd_collection(
  dir = "./",
  pattern = "*.qmd",
  all = FALSE,
  recurse = TRUE,
  regex = FALSE
)

parse_rmd_collection(
  dir = "./",
  pattern = "*.Rmd",
  all = FALSE,
  recurse = TRUE,
  regex = FALSE
)
}
\arguments{
\item{dir}{Directory to search}

\item{pattern}{Pattern to match files, defaults to glob syntax}

\item{all}{Search includes hidden files}

\item{recurse}{Search recusively within \code{dir}}

\item{regex}{Treat \code{pattern} as a regular expression syntax for \code{pattern}}
}
\value{
Returns a \code{tibble} object with columns for document \code{name}, \code{path}, and \code{ast}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Recursively searches a directory for R Markdown or Quarto documents and parses them into a collection of
\code{rmd_ast} objects
}
\examples{
parse_rmd_collection(system.file("examples/", package="parsermd"))

}
