% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioning_functions.R
\name{classic_partition}
\alias{classic_partition}
\title{Calculate classic partition}
\usage{
classic_partition(DRY, M, N = length(M), Q = N,
  uncorrected_cov = FALSE)
}
\arguments{
\item{DRY}{change in relative yield, as calculated by the calculate_DRY function}

\item{M}{monoculture biomass}

\item{N}{number of species in the sample - defaults to length(M)}

\item{Q}{number of species in the full population - defaults to N - only required if uncorrected_cov="COMP"}

\item{uncorrected_cov}{A character, which can be TRUE, FALSE, or COMP. Tells whether to use the standard sample-size corrected covariance function (FALSE), or
a covariance function that is not corrected for sample size (TRUE), or
a "compromise" function that resembles the standard function for N < Q, and that resembles the non-corrected function for N ~ Q
If TRUE, then SS + CS = YO - YE, sensu Loreau and Hector 2001
defaults to FALSE
note - we do not recommend setting this to TRUE or "COMP", unless you require SS+CS=YO-YE}
}
\value{
a list with elements S (the selection effect) and C (the complementarity effect)
}
\description{
calculates the classic selection and complementarity effects, sensu Loreau and Hector 2001
}
