% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_create_agent_action_group}
\alias{bedrockagent_create_agent_action_group}
\title{Creates an action group for an agent}
\usage{
bedrockagent_create_agent_action_group(
  actionGroupExecutor = NULL,
  actionGroupName,
  actionGroupState = NULL,
  agentId,
  agentVersion,
  apiSchema = NULL,
  clientToken = NULL,
  description = NULL,
  functionSchema = NULL,
  parentActionGroupSignature = NULL
)
}
\arguments{
\item{actionGroupExecutor}{The Amazon Resource Name (ARN) of the Lambda function containing the
business logic that is carried out upon invoking the action or the
custom control method for handling the information elicited from the
user.}

\item{actionGroupName}{[required] The name to give the action group.}

\item{actionGroupState}{Specifies whether the action group is available for the agent to invoke
or not when sending an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html}{InvokeAgent}
request.}

\item{agentId}{[required] The unique identifier of the agent for which to create the action group.}

\item{agentVersion}{[required] The version of the agent for which to create the action group.}

\item{apiSchema}{Contains either details about the S3 object containing the OpenAPI
schema for the action group or the JSON or YAML-formatted payload
defining the schema. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html}{Action group OpenAPI schemas}.}

\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{description}{A description of the action group.}

\item{functionSchema}{Contains details about the function schema for the action group or the
JSON or YAML-formatted payload defining the schema.}

\item{parentActionGroupSignature}{To allow your agent to request the user for additional information when
trying to complete a task, set this field to \code{AMAZON.UserInput}. You
must leave the \code{description}, \code{apiSchema}, and \code{actionGroupExecutor}
fields blank for this action group.

To allow your agent to generate, run, and troubleshoot code when trying
to complete a task, set this field to \code{AMAZON.CodeInterpreter}. You must
leave the \code{description}, \code{apiSchema}, and \code{actionGroupExecutor} fields
blank for this action group.

During orchestration, if your agent determines that it needs to invoke
an API in an action group, but doesn't have enough information to
complete the API request, it will invoke this action group instead and
return an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html}{Observation}
reprompting the user for more information.}
}
\description{
Creates an action group for an agent. An action group represents the actions that an agent can carry out for the customer by defining the APIs that an agent can call and the logic for calling them.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_action_group/} for full documentation.
}
\keyword{internal}
