% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_parameters_by_path}
\alias{ssm_get_parameters_by_path}
\title{Retrieve information about one or more parameters under a specified
level in a hierarchy}
\usage{
ssm_get_parameters_by_path(
  Path,
  Recursive = NULL,
  ParameterFilters = NULL,
  WithDecryption = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Path}{[required] The hierarchy for the parameter. Hierarchies start with a forward slash
(/). The hierarchy is the parameter name except the last part of the
parameter. For the API call to succeed, the last part of the parameter
name can't be in the path. A parameter name hierarchy can have a maximum
of 15 levels. Here is an example of a hierarchy:
\verb{/Finance/Prod/IAD/WinServ2016/license33 }}

\item{Recursive}{Retrieve all parameters within a hierarchy.

If a user has access to a path, then the user can access all levels of
that path. For example, if a user has permission to access path \verb{/a},
then the user can also access \verb{/a/b}. Even if a user has explicitly been
denied access in IAM for parameter \verb{/a/b}, they can still call the
GetParametersByPath API operation recursively for \verb{/a} and view \verb{/a/b}.}

\item{ParameterFilters}{Filters to limit the request results.

The following \code{Key} values are supported for
\code{\link[=ssm_get_parameters_by_path]{get_parameters_by_path}}: \code{Type}, \code{KeyId},
and \code{Label}.

The following \code{Key} values aren't supported for
\code{\link[=ssm_get_parameters_by_path]{get_parameters_by_path}}: \code{tag},
\code{DataType}, \code{Name}, \code{Path}, and \code{Tier}.}

\item{WithDecryption}{Retrieve all parameters in a hierarchy with their value decrypted.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}
}
\description{
Retrieve information about one or more parameters under a specified level in a hierarchy.

See \url{https://www.paws-r-sdk.com/docs/ssm_get_parameters_by_path/} for full documentation.
}
\keyword{internal}
