% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_upload_part_copy}
\alias{s3_upload_part_copy}
\title{Uploads a part by copying data from an existing object as data source}
\usage{
s3_upload_part_copy(
  Bucket,
  CopySource,
  CopySourceIfMatch = NULL,
  CopySourceIfModifiedSince = NULL,
  CopySourceIfNoneMatch = NULL,
  CopySourceIfUnmodifiedSince = NULL,
  CopySourceRange = NULL,
  Key,
  PartNumber,
  UploadId,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  CopySourceSSECustomerAlgorithm = NULL,
  CopySourceSSECustomerKey = NULL,
  CopySourceSSECustomerKeyMD5 = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL,
  ExpectedSourceBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name.

\strong{Directory buckets} - When you use this operation with a directory
bucket, you must use virtual-hosted-style requests in the format
\code{ Bucket-name.s3express-zone-id.region-code.amazonaws.com}. Path-style
requests are not supported. Directory bucket names must be unique in the
chosen Zone (Availability Zone or Local Zone). Bucket names must follow
the format \code{ bucket-base-name--zone-id--x-s3} (for example,
\code{ amzn-s3-demo-bucket--usw2-az1--x-s3}). For information about bucket
naming restrictions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html}{Directory bucket naming rules}
in the \emph{Amazon S3 User Guide}.

Copying objects across different Amazon Web Services Regions isn't
supported when the source or destination bucket is in Amazon Web
Services Local Zones. The source and destination buckets must have the
same parent Amazon Web Services Region. Otherwise, you get an HTTP
\verb{400 Bad Request} error with the error code \code{InvalidRequest}.

\strong{Access points} - When you use this action with an access point, you
must provide the alias of the access point in place of the bucket name
or specify the access point ARN. When using the access point ARN, you
must direct requests to the access point hostname. The access point
hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

Access points and Object Lambda access points are not supported by
directory buckets.

\strong{S3 on Outposts} - When you use this action with S3 on Outposts, you
must direct requests to the S3 on Outposts hostname. The S3 on Outposts
hostname takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts, the destination bucket
must be the Outposts access point ARN or the access point alias. For
more information about S3 on Outposts, see \href{https://docs.aws.amazon.com/AmazonS3/latest/s3-outposts/S3onOutposts.html}{What is S3 on Outposts?}
in the \emph{Amazon S3 User Guide}.}

\item{CopySource}{[required] Specifies the source object for the copy operation. You specify the
value in one of two formats, depending on whether you want to access the
source object through an \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html}{access point}:
\itemize{
\item For objects not accessed through an access point, specify the name
of the source bucket and key of the source object, separated by a
slash (/). For example, to copy the object \code{reports/january.pdf}
from the bucket \code{awsexamplebucket}, use
\code{awsexamplebucket/reports/january.pdf}. The value must be
URL-encoded.
\item For objects accessed through access points, specify the Amazon
Resource Name (ARN) of the object as accessed through the access
point, in the format
\verb{arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through access
point \code{my-access-point} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf}.
The value must be URL encoded.
\itemize{
\item Amazon S3 supports copy operations using Access points only when
the source and destination buckets are in the same Amazon Web
Services Region.
\item Access points are not supported by directory buckets.
}

Alternatively, for objects accessed through Amazon S3 on Outposts,
specify the ARN of the object as accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through
outpost \code{my-outpost} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf}.
The value must be URL-encoded.
}

If your bucket has versioning enabled, you could have multiple versions
of the same object. By default, \code{x-amz-copy-source} identifies the
current version of the source object to copy. To copy a specific version
of the source object to copy, append \verb{?versionId=<version-id>} to the
\code{x-amz-copy-source} request header (for example,
\verb{x-amz-copy-source: /awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893}).

If the current version is a delete marker and you don't specify a
versionId in the \code{x-amz-copy-source} request header, Amazon S3 returns a
\verb{404 Not Found} error, because the object does not exist. If you specify
versionId in the \code{x-amz-copy-source} and the versionId is a delete
marker, Amazon S3 returns an HTTP \verb{400 Bad Request} error, because you
are not allowed to specify a delete marker as a version for the
\code{x-amz-copy-source}.

\strong{Directory buckets} - S3 Versioning isn't enabled and supported for
directory buckets.}

\item{CopySourceIfMatch}{Copies the object if its entity tag (ETag) matches the specified tag.

If both of the \verb{x-amz-copy-source-if-match} and
\verb{x-amz-copy-source-if-unmodified-since} headers are present in the
request as follows:

\verb{x-amz-copy-source-if-match} condition evaluates to \code{true}, and;

\verb{x-amz-copy-source-if-unmodified-since} condition evaluates to \code{false};

Amazon S3 returns \verb{200 OK} and copies the data.}

\item{CopySourceIfModifiedSince}{Copies the object if it has been modified since the specified time.

If both of the \verb{x-amz-copy-source-if-none-match} and
\verb{x-amz-copy-source-if-modified-since} headers are present in the request
as follows:

\verb{x-amz-copy-source-if-none-match} condition evaluates to \code{false}, and;

\verb{x-amz-copy-source-if-modified-since} condition evaluates to \code{true};

Amazon S3 returns \verb{412 Precondition Failed} response code.}

\item{CopySourceIfNoneMatch}{Copies the object if its entity tag (ETag) is different than the
specified ETag.

If both of the \verb{x-amz-copy-source-if-none-match} and
\verb{x-amz-copy-source-if-modified-since} headers are present in the request
as follows:

\verb{x-amz-copy-source-if-none-match} condition evaluates to \code{false}, and;

\verb{x-amz-copy-source-if-modified-since} condition evaluates to \code{true};

Amazon S3 returns \verb{412 Precondition Failed} response code.}

\item{CopySourceIfUnmodifiedSince}{Copies the object if it hasn't been modified since the specified time.

If both of the \verb{x-amz-copy-source-if-match} and
\verb{x-amz-copy-source-if-unmodified-since} headers are present in the
request as follows:

\verb{x-amz-copy-source-if-match} condition evaluates to \code{true}, and;

\verb{x-amz-copy-source-if-unmodified-since} condition evaluates to \code{false};

Amazon S3 returns \verb{200 OK} and copies the data.}

\item{CopySourceRange}{The range of bytes to copy from the source object. The range value must
use the form bytes=first-last, where the first and last are the
zero-based byte offsets to copy. For example, bytes=0-9 indicates that
you want to copy the first 10 bytes of the source. You can copy a range
only if the source object is greater than 5 MB.}

\item{Key}{[required] Object key for which the multipart upload was initiated.}

\item{PartNumber}{[required] Part number of part being copied. This is a positive integer between 1
and 10,000.}

\item{UploadId}{[required] Upload ID identifying the multipart upload whose part is being copied.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use when encrypting the object (for example,
AES256).

This functionality is not supported when the destination bucket is a
directory bucket.}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header. This must be
the same encryption key specified in the initiate multipart upload
request.

This functionality is not supported when the destination bucket is a
directory bucket.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.

This functionality is not supported when the destination bucket is a
directory bucket.}

\item{CopySourceSSECustomerAlgorithm}{Specifies the algorithm to use when decrypting the source object (for
example, \code{AES256}).

This functionality is not supported when the source object is in a
directory bucket.}

\item{CopySourceSSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use to
decrypt the source object. The encryption key provided in this header
must be one that was used when the source object was created.

This functionality is not supported when the source object is in a
directory bucket.}

\item{CopySourceSSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.

This functionality is not supported when the source object is in a
directory bucket.}

\item{RequestPayer}{}

\item{ExpectedBucketOwner}{The account ID of the expected destination bucket owner. If the account
ID that you provide does not match the actual owner of the destination
bucket, the request fails with the HTTP status code \verb{403 Forbidden}
(access denied).}

\item{ExpectedSourceBucketOwner}{The account ID of the expected source bucket owner. If the account ID
that you provide does not match the actual owner of the source bucket,
the request fails with the HTTP status code \verb{403 Forbidden} (access
denied).}
}
\description{
Uploads a part by copying data from an existing object as data source. To specify the data source, you add the request header \code{x-amz-copy-source} in your request. To specify a byte range, you add the request header \code{x-amz-copy-source-range} in your request.

See \url{https://www.paws-r-sdk.com/docs/s3_upload_part_copy/} for full documentation.
}
\keyword{internal}
