% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{Idom.numASup.bnd.tri}
\alias{Idom.numASup.bnd.tri}
\title{Indicator for an upper bound for the domination number of Arc Slice Proximity Catch Digraph
(AS-PCD) by the exact algorithm - one triangle case}
\usage{
Idom.numASup.bnd.tri(Xp, k, tri, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{k}{A positive integer to be tested for an upper bound for the domination number of AS-PCDs.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{domUB}{The suggested upper bound (to be checked) for the domination number of AS-PCD.
It is prespecified as \code{k} in the function arguments.}
\item{Idom.num.up.bnd}{The indicator for the upper bound for domination number of AS-PCD being the
specified value \code{k} or not. It returns 1 if the upper bound is \code{k}, and 0 otherwise.}
\item{ind.dom.set}{The vertices (i.e., data points) in the dominating set of size \code{k} if it exists,
otherwise it yields \code{NULL}.}
}
\description{
Returns \eqn{I(}domination number of AS-PCD whose vertices are the data points \code{Xp} is less than or equal to \code{k}\eqn{)},
that is, returns 1 if the domination number of AS-PCD is less than the prespecified value \code{k}, returns 0
otherwise. It also provides the vertices (i.e., data points) in a dominating set of size \code{k} of AS-PCD.

AS proximity regions are constructed with respect to the triangle \code{tri} and
vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on circumcenter of  \code{tri};
default is \code{M="CC"}, i.e., circumcenter of \code{tri}.

The vertices of \code{tri}angle, \code{tri},
are labeled as \eqn{1,2,3} according to the row number the vertex is recorded in \code{tri}.
Loops are allowed in the digraph.
It takes a long time for large number of vertices (i.e., large number of row numbers).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$gen.points

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

Idom.numASup.bnd.tri(Xp,1,Tr)

for (k in 1:n)
  print(c(k,Idom.numASup.bnd.tri(Xp,k,Tr,M)))

Idom.numASup.bnd.tri(Xp,k=4,Tr,M)

P<-c(.4,.2)
Idom.numASup.bnd.tri(P,1,Tr,M)

Idom.numASup.bnd.tri(rbind(Xp,Xp),k=2,Tr,M)
}

}
\seealso{
\code{\link{Idom.numCSup.bnd.tri}}, \code{\link{Idom.numCSup.bnd.std.tri}}, \code{\link{Idom.num.up.bnd}},
and \code{\link{dom.num.exact}}
}
\author{
Elvan Ceyhan
}
