% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{arcsPE}
\alias{arcsPE}
\title{The arcs of Proportional Edge Proximity Catch Digraph (PE-PCD)
for 2D data - multiple triangle case}
\usage{
arcsPE(Xp, Yp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle
(for this, argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)}
which is the center of mass of each triangle.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph,
the center used to construct the vertex regions
and the expansion parameter.}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation
of the study region is performed,
here, tessellation is the Delaunay triangulation based on \code{Yp} points.}
\item{tess.name}{Name of the tessellation points \code{tess.points}}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set
which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of PE-PCD for 2D data set \code{Xp}
as vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of PE-PCD for 2D data set \code{Xp}
as vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title
in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices,
number of partition points,
number of triangles, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs of PE-PCD as tails (or sources) and heads (or arrow ends)
and related parameters and the quantities of the digraph.
The vertices of the PE-PCD are the data points in \code{Xp}
in the multiple triangle case.

PE proximity regions are
defined with respect to the Delaunay triangles
based on \code{Yp} points with expansion parameter \eqn{r \ge 1} and
vertex regions in each triangle are
based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates
in the interior of each Delaunay triangle or
based on circumcenter of each Delaunay triangle
(default for \eqn{M=(1,1,1)}
which is the center of mass of the triangle).
Each Delaunay triangle is first converted to
an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle
(this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
For the number of arcs, loops are not allowed so arcs are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds})
for more on the PE-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

r<-1.5  #try also r<-2

Arcs<-arcsPE(Xp,Yp,r,M)
#or try with the default center Arcs<-arcsPE(Xp,Yp,r)
Arcs
summary(Arcs)
plot(Arcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{arcsPEtri}}, \code{\link{arcsAS}},
and \code{\link{arcsCS}}
}
\author{
Elvan Ceyhan
}
