% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{kfr2vertsCCvert.reg.basic.tri}
\alias{kfr2vertsCCvert.reg.basic.tri}
\title{The \code{k} furthest points from vertices
in each \eqn{CC}-vertex region in a standard basic triangle}
\usage{
kfr2vertsCCvert.reg.basic.tri(Xp, c1, c2, k, ch.all.intri = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points
representing the set of data points.}

\item{c1, c2}{Positive real numbers
which constitute the vertex of the standard basic triangle.
adjacent to the shorter edges;
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}}

\item{k}{A positive integer. \code{k} furthest data points
in each \eqn{CC}-vertex region are to be found if exists, else
\code{NA} are provided for (some of) the \code{k} furthest points.}

\item{ch.all.intri}{A logical argument for checking
whether all data points are inside \eqn{T_b}
(default is \code{FALSE}).}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2},
and \eqn{C=3} (correspond to row number in Extremum Points).}
\item{txt2}{A shorter description of the distances
as \code{"Distances of k furthest points in the vertex regions to Vertices"}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here,
\code{k} furthest points from vertices in each vertex region.}
\item{X}{The input data, \code{Xp}, can be a \code{matrix}
or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points,
here, it is \eqn{T_b}.}
\item{cent}{The center point used for construction of edge regions.}
\item{ncent}{Name of the center, \code{cent},
it is circumcenter \code{"CC"} for this function.}
\item{regions}{Vertex regions inside the triangle, \eqn{T_b},
provided as a \code{list}.}
\item{region.names}{Names of the vertex regions
as \code{"vr=1"}, \code{"vr=2"}, and \code{"vr=3"}}
\item{region.centers}{Centers of mass of the vertex regions inside \eqn{T_b}.}
\item{dist2ref}{Distances from \code{k} furthest points
in each vertex region to the corresponding vertex
(each row representing a vertex).}
}
\description{
An object of class \code{"Extrema"}.
Returns the \code{k} furthest data points
among the data set, \code{Xp},
in each \eqn{CC}-vertex region from the vertex in the
standard basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))}.

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the
original triangle. Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

\code{ch.all.intri} is for checking whether all data points are
inside \eqn{T_b} (default is \code{FALSE}).
In the extrema, \eqn{ext}, in the output,
the first \code{k} entries are the \code{k} furthest points from vertex 1,
second \code{k} entries are \code{k} furthest points are from vertex 2, and
last \code{k} entries are the \code{k} furthest points from vertex 3
 If data size does not allow, \code{NA}'s are inserted for some
 or all of the \code{k} furthest points for each vertex.
}
\examples{
\donttest{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-20
k<-3

set.seed(1)
Xp<-runif.basic.tri(n,c1,c2)$g

Ext<-kfr2vertsCCvert.reg.basic.tri(Xp,c1,c2,k)
Ext
summary(Ext)
plot(Ext)

kf2v<-Ext

CC<-circumcenter.basic.tri(c1,c2)  #the circumcenter
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tb[,1],Xp[,1])
Ylim<-range(Tb[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",asp=1,xlab="",ylab="",
main=paste(k," Furthest Points in CC-Vertex Regions \n from the Vertices",sep=""),
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(Xp)
points(kf2v$ext,pch=4,col=2)

txt<-rbind(Tb,CC,Ds)
xc<-txt[,1]+c(-.03,.03,.02,.07,.06,-.05,.01)
yc<-txt[,2]+c(.02,.02,.03,-.02,.02,.03,-.04)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)
}

}
\seealso{
\code{\link{fr2vertsCCvert.reg.basic.tri}}, \code{\link{fr2vertsCCvert.reg}},
\code{\link{fr2edgesCMedge.reg.std.tri}}, and \code{\link{kfr2vertsCCvert.reg}}
}
\author{
Elvan Ceyhan
}
