% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{prj.nondegPEcent2edges}
\alias{prj.nondegPEcent2edges}
\title{Projections of Centers for non-degenerate asymptotic distribution of
domination number of Proportional Edge Proximity Catch Digraphs
(PE-PCDs) to its edges}
\usage{
prj.nondegPEcent2edges(tri, r, cent = 1)
}
\arguments{
\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number which serves
as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} for this function.}

\item{cent}{Index of the center (as \eqn{1,2,3}
corresponding to \eqn{M_1,\,M_2,\,M_3})
which gives nondegenerate asymptotic
distribution of the domination number of PE-PCD
for uniform data in \code{tri} for expansion parameter \code{r}
in \eqn{(1,1.5]};
default \code{cent=1}.}
}
\value{
Three projection points (stacked row-wise)
from one of the centers (as \eqn{1,2,3} corresponding to
\eqn{M_1,\,M_2,\,M_3})
which gives nondegenerate asymptotic distribution of
the domination number of PE-PCD for
uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]}.
}
\description{
Returns the projections
from center \code{cent} to the edges on the extension of the lines
joining \code{cent} to the vertices
in the triangle, \code{tri}. Here M is one of the three centers
which gives nondegenerate asymptotic distribution
of the domination number of PE-PCD for uniform data in \code{tri}
for a given expansion parameter \code{r} in \eqn{(1,1.5]}.
The center label \code{cent} values \code{1,2,3} correspond
to the vertices \eqn{M_1}, \eqn{M_2},
and \eqn{M_3} (i.e., row numbers in the
output of \code{center.nondegPE(tri,r)}); default for \code{cent} is 1.
\code{cent} becomes center of mass \eqn{CM} for \eqn{r=1.5}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
r<-1.35

prj.nondegPEcent2edges(Tr,r,cent=2)

Ms<-center.nondegPE(Tr,r)
M1=Ms[1,]

Ds<-prj.nondegPEcent2edges(Tr,r,cent=1)

Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",
main="Projections from a non-degeneracy center\n to the edges of the triangle",
axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Ms,pch=".",col=1)
polygon(Ms,lty = 2)

xc<-Tr[,1]+c(-.02,.03,.02)
yc<-Tr[,2]+c(-.02,.04,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-Ms
xc<-txt[,1]+c(-.02,.04,-.04)
yc<-txt[,2]+c(-.02,.04,.04)
txt.str<-c("M1","M2","M3")
text(xc,yc,txt.str)

points(Ds,pch=4,col=2)
L<-rbind(M1,M1,M1); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty = 2,lwd=2,col=4)
txt<-Ds
xc<-txt[,1]+c(-.02,.04,-.04)
yc<-txt[,2]+c(-.02,.04,.04)
txt.str<-c("D1","D2","D3")
text(xc,yc,txt.str)

prj.nondegPEcent2edges(Tr,r,cent=3)
#gives an error message if center index, cent, is different from 1, 2 or 3
prj.nondegPEcent2edges(Tr,r=1.49,cent=2)
#gives an error message if r>1.5
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{prj.cent2edges.basic.tri}} and \code{\link{prj.cent2edges}}
}
\author{
Elvan Ceyhan
}
