% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{runif.tri}
\alias{runif.tri}
\title{Generation of Uniform Points in a Triangle}
\usage{
runif.tri(n, tri)
}
\arguments{
\item{n}{A positive integer representing the number of uniform points
to be generated in the triangle.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}
}
\value{
A \code{list} with the elements
\item{type}{The type of the pattern
from which points are to be generated}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{tess.points}{The vertices of the support of
the uniformly generated points, it is the triangle
\code{tri} for this function}
\item{gen.points}{The output set of generated points uniformly
in the triangle, \code{tri}.}
\item{out.region}{The outer region which contains the support region,
\code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern
from which points are to be generated}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and the number
of vertices of the support points (here it is 3).}
\item{txt4pnts}{Description of the two numbers in \code{num.points}}
\item{xlimit,ylimit}{The ranges of the \eqn{x}-
and \eqn{y}-coordinates of the support, \code{tri}}
}
\description{
An object of class \code{"Uniform"}.
Generates \code{n} points uniformly in a given triangle, \code{tri}
}
\examples{
\donttest{
n<-100
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C)

Xdt<-runif.tri(n,Tr)
Xdt
summary(Xdt)
plot(Xdt)

Xp<-Xdt$g
Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
plot(Tr,pch=".",xlab="",ylab="",main="Uniform Points in One Triangle",
     xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp)
xc<-Tr[,1]+c(-.02,.02,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)
}

}
\seealso{
\code{\link{runif.std.tri}}, \code{\link{runif.basic.tri}},
and \code{\link{runif.multi.tri}}
}
\author{
Elvan Ceyhan
}
