% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenetic.R
\name{pre_tax_table}
\alias{pre_tax_table}
\title{Complete a taxonomy table}
\usage{
pre_tax_table(
  tax_table,
  tax_levels = c("k", "p", "c", "o", "f", "g", "s", "st"),
  na_tax = "Unclassified|uncultured|Ambiguous|Unknown|unknown|metagenome|Unassig",
  ignore.case = TRUE,
  na_repalce = "Unknown",
  add_prefix = TRUE
)
}
\arguments{
\item{tax_table}{taxonomy table}

\item{tax_levels}{a vector whose length longer than \code{ncol(taxdf)}, use to be prefix. Default: c("k", "p", "c", "o", "f", "g","s", "st")}

\item{na_tax}{grepl some words and turn to \code{na_repalce}, default: "Unclassified|uncultured|Ambiguous|Unknown|unknown|metagenome|Unassig"}

\item{ignore.case}{ignore.case for \code{na_tax}}

\item{na_repalce}{defalut: Unknown}

\item{add_prefix}{add prefix? logical}
}
\value{
a good taxonomy table
}
\description{
Complete a taxonomy table
}
\examples{
taxmat <- matrix(sample("onelevel", 7 * 2, replace = TRUE), nrow = 2, ncol = 7) \%>\% as.data.frame()
colnames(taxmat) <- c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species")
pre_tax_table(taxmat)
}
\references{
\code{MicrobiotaProcess}
}
