% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend_A.R
\name{detrend_A}
\alias{detrend_A}
\title{detrend_A}
\usage{
detrend_A(x, x_values, y, detrend_A_position = "center")
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{x_values}{numerical vector with distance (time markers) between observations}

\item{y}{numeric vector with the observed y-values}

\item{detrend_A_position}{character to indicate the mean}
}
\value{
List with the trend and the detrended y-values:
  x_values_A_trend = vector with distance (time markers) between A-detrended signal,
  y_A_trend = vector with computed A-trend,
  y_detrended = vector with computed A-detrended y values.
}
\description{
Detrends the phase A part of time series y.
detrend A is optional and not validated.
The mean of the detrended signal will be set to the predicted value based on detrend_A_position:
detrend_A_position = "first" : take predicted value for first valid observation
detrend_A_position = "center" : take predicted value for center observation
detrend_A_position = "last" : take predicted value for last valid observation.
}
\examples{
pdt::detrend_A(as.factor(c(rep("A",20), rep("B",20))), 1:40,
  c(rnorm(20), rnorm(20)+2), detrend_A_position="center")

}
