#' @name sentiment
#'
#' @description Fictitious sentiment data for employees in a mid-size company
#'
#' @docType data
#'
#' @usage data(sentiment)
#'
#' @format A dataframe containing 1,470 observations and 6 variables:
#'
#' @param employee_id
#'      Unique identifier for each employee
#'
#' @param env_sat
#'      Environment satisfaction score measured on a 4-point Likert scale, where 1 = 'Highly Dissatisfied' and 4 = 'Highly Satisfied'
#'
#' @param engagement
#'      Employee engagement score measured on a 4-point Likert scale, where 1 = 'Highly Disengaged' and 4 = 'Highly Engaged'
#'
#' @param job_sat
#'      Job satisfaction score measured on a 4-point Likert scale, where 1 = 'Highly Dissatisfied' and 4 = 'Highly Satisfied'
#'
#' @param rel_sat
#'      Colleague relationship satisfaction score measured on a 4-point Likert scale, where 1 = 'Highly Dissatisfied' and 4 = 'Highly Satisfied'
#'
#' @param wl_balance
#'      Work-life balance score measured on a 4-point Likert scale, where 1 = 'Poor Balance' and 4 = 'Excellent Balance'
#'
#' @examples data(sentiment)
