% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_test.R
\name{permutation_test}
\alias{permutation_test}
\title{Run permutation test}
\usage{
permutation_test(
  df,
  group_col,
  outcome_col,
  strata_col = NULL,
  test_stat = "diff_in_means",
  perm_func = permute_group,
  alternative = "two-sided",
  shift = 0,
  reps = 10000,
  perm_set = NULL,
  complete_enum = FALSE,
  return_test_dist = FALSE,
  return_perm_dist = FALSE,
  seed = NULL
)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{outcome_col}{The name of the column in df that corresponds to the outcome variable}

\item{strata_col}{The name of the column in df that corresponds to the strata}

\item{test_stat}{Test statistic function}

\item{perm_func}{Function to permute group}

\item{alternative}{String, two-sided or one-sided (greater or less) p-value; options are 'greater', 'less', or 'two-sided'}

\item{shift}{Value of shift to apply in one- or two-sample problem}

\item{reps}{Number of iterations to use when calculating permutation p-value}

\item{perm_set}{Matrix of group assignments to use instead of reps iterations of perm_func}

\item{complete_enum}{Boolean, whether to calculate P-value under complete enumeration of permutations}

\item{return_test_dist}{Boolean, whether to return test statistic distribution under permutations}

\item{return_perm_dist}{Boolean, whether to return a matrix where each row is the group assignment under that permutation}

\item{seed}{An integer seed value}
}
\value{
\code{p_value}: the permutation test p-value

\code{test_stat_dist}: array, the distribution of the test statistic under the set of permutations,
if return_test_dist is set to TRUE

\code{perm_indices_mat}: matrix, each row corresponds to a permutation used
in the permutation test calculation
}
\description{
Run permutation test with user inputted data, test statistic, and permutation function
}
\examples{
data <- data.frame(group = c(rep(1, 10), rep(2, 10)), outcome = c(rep(1, 10), rep(1, 10)))

permutation_test(df = data, group_col = "group", outcome_col = "outcome",
test_stat = "diff_in_means", perm_func = permute_group, alternative = "greater",
shift = 0, reps = 10, return_perm_dist = TRUE, return_test_dist = TRUE, seed = 42)

}
