% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlm.R
\name{lmeSummary}
\alias{lmeSummary}
\title{Summarize mixed effects model.}
\usage{
lmeSummary(model, dig = 3)
}
\arguments{
\item{model}{name of \code{lme()} model object.}

\item{dig}{number of decimals to print in output.}
}
\value{
Output summary of \code{lme()} model object.
}
\description{
Summarizes the results of a model fit by the \code{lme()} function of the
\code{nlme} package.
}
\details{
Summarizes the results of a model fit by the \code{lme()} function of the
\code{nlme} package. Includes summary of parameters, pseudo-r-squared, and
whether model is positive definite.
}
\examples{
# Fit Model
library("nlme")
model <- lme(distance ~ age + Sex, data = Orthodont, random = ~ 1 + age)

# Model Summary
summary(model)
lmeSummary(model)
}
\seealso{
Other mixedModel: 
\code{\link{lm.beta.lmer}()}
}
\concept{mixedModel}
