% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{orientation}
\alias{orientation}
\alias{orientation<-}
\alias{set_orientation}
\title{Return or set orientation}
\usage{
orientation(x, ...)

orientation(x) <- value

set_orientation(x, value)
}
\arguments{
\item{x}{A \code{rtf_doc} object}

\item{...}{Additonal arguments passed to method dispatch}

\item{value}{A character vector of either 'landscape' or 'portrait'}
}
\value{
For \code{orientation()}, the orientation attribute of the supplied
  \code{rtf_doc} object. For \code{`orientation<-()`} and
  \code{set_orientation()} the modified object.
}
\description{
These property functions modify or return the orientation attribute of a
\code{rtf_doc} object. Options are landscape or portrait. See the \code{\link{rtf_doc}}
help page for important notes about this property.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle")))

orientation(rtf)
# Returns landscape

orientation(rtf) <- "portrait"
# Sets orientation to portrait

}
