% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_lock_step}
\alias{pipe_lock_step}
\alias{pipe_unlock_step}
\title{Lock steps}
\usage{
pipe_lock_step(pip, step)

pipe_unlock_step(pip, step)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} name of step to lock or unlock}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Locking a step means that both its parameters and its
output (given it has output) are locked such that neither
setting new pipeline parameters nor future pipeline runs can change
the current parameter and output content. To unlock a locked step,
use \code{\link[=pipe_unlock_step]{pipe_unlock_step()}}.
}
\examples{
# pipe_lock_step
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = 1, data = ~data) x + data)
pipe_add(p, "add2", \(x = 1, data = ~data) x + data)
pipe_run(p)
pipe_get_out(p, "add1")
pipe_get_out(p, "add2")
pipe_lock_step(p, "add1")

pipe_set_data(p, 3)
pipe_set_params(p, list(x = 3))
pipe_run(p)
pipe_get_out(p, "add1")
pipe_get_out(p, "add2")

# pipe_unlock_step
pipe_unlock_step(p, "add1")
pipe_set_params(p, list(x = 3))
pipe_run(p)
pipe_get_out(p, "add1")
}
