% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plug.R
\name{plug_get_valid_token}
\alias{plug_get_valid_token}
\title{Get a valid token for Plug API}
\usage{
plug_get_valid_token(
  validity_time = 3600,
  endpoint = "https://plug.der.pe.gov.br/MadrixApi/authenticate/"
)
}
\arguments{
\item{validity_time}{The validity period of the token in seconds. Default is 3600 (1 hour).}

\item{endpoint}{The endpoint URL for generating the token.}
}
\value{
The valid token as a string, or \code{NULL} if no valid credentials were found or an error occurred.
}
\description{
This function checks if a valid global token exists for the Plug API. If no valid token is found,
it generates a new token using the stored global credentials by sending a properly formatted request.
If it fails to retrieve the token (for example, due to missing credentials or network issues),
it will not throw an error but will display a message in English ("No valid credentials found.") and return \code{NULL}.
}
\examples{
\donttest{
\dontrun{
token <- plug_get_valid_token(validity_time = 3600)
}
}
}
