% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_deploy_api}
\alias{do_deploy_api}
\title{Deploy or Update an API}
\usage{
do_deploy_api(
  droplet,
  path,
  localPath,
  port,
  forward = FALSE,
  docs = FALSE,
  preflight,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{droplet}{The droplet on which to act. It's expected that this droplet
was provisioned using \code{\link[=do_provision]{do_provision()}}.  See \code{\link[analogsea:droplet]{analogsea::droplet()}} to
obtain a reference to a running droplet.}

\item{path}{The remote path/name of the application}

\item{localPath}{The local path to the API that you want to deploy. The
entire directory referenced will be deployed, and the \code{plumber.R} file
inside of that directory will be used as the root plumber file. The
directory MUST contain a \code{plumber.R} file.}

\item{port}{The internal port on which this service should run. This will not
be user visible, but must be unique and point to a port that is available
on your server. If unsure, try a number around \code{8000}.}

\item{forward}{If \code{TRUE}, will setup requests targeting the root URL on the
server to point to this application. See the \code{\link[=do_forward]{do_forward()}} function for
more details.}

\item{docs}{If \code{TRUE}, will enable the documentation interface for the remotely
deployed API. By default, the interface is disabled.}

\item{preflight}{R commands to run after \code{plumb()}ing the \code{plumber.R} file,
but before \code{run()}ing the plumber service. This is an opportunity to e.g.
add new filters. If you need to specify multiple commands, they should be
semi-colon-delimited.}

\item{overwrite}{if an application is already running for this \code{path} name,
and \code{overwrite = TRUE}, then \code{do_remove_api} will be run.}

\item{...}{additional arguments to pass to \code{\link[analogsea:droplet_ssh]{analogsea::droplet_ssh()}} or
\code{\link[analogsea:droplet_ssh]{analogsea::droplet_upload()}}, such as \code{keyfile}.
Cannot contain \code{remote}, \code{local} as named arguments.}
}
\value{
The DigitalOcean droplet, but called for side effects
}
\description{
Deploys an API from your local machine to make it available on the remote
plumber server.
}
